//EX 6 Program Title:Determine output resistance, βdc and βac of Common Emitter configuration.///
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
//////////////////////////////////////////////////////////////////
disp('******On the output characteristics of CE confi. in active region select an operating point(VCEQ,ICQ) on load line*********');
ICQ1=input("Enter the value of ICQ on the curve in mA ICQ: ");    //Note:Press enter
//draw horizontal line from operating point//0 mA to 10 mA
IB1=input("Enter the value of IB corresponding to ICQ in uA IB: ");  //Note:Press enter
VCEQ=input("Enter the Corresponding value of VCEQ : ");          //Note:Press enter// Draw vertical line from operating point   //VCEQ is in the range of 0V to 20V
mprintf('\n. \*********************************************************\');
ICQ=ICQ1*1e-3;
IB=IB1*1e-6;
mprintf('\n Operating point Collector Current           ICQ:%1f A',ICQ);
mprintf('\n Corresponding Base Current                  IB:%1f A',IB);
mprintf('\n Recspective Collector to Emitter voltage is VCEQ:%1fV',VCEQ)
/////////////////////////////////////////////////////////////////
//******************Solution*******************************\');
//////////////Calculate Beta DC//////////////////////////////////
mprintf('\n. \*********************************************************\');
Beta_DC=ICQ/IB;   // DC current gain
mprintf('\n 1)DC current gain of transistor in CE Confi.  Beta_DC=%2d ',Beta_DC);
mprintf('\n. \***********************Calculation of βac*****************\');
//For  calculation of βac by taking change(ib1 ib2) in base current on either side of Q-pointalong the vertical axis of about equal distance to either side of Q-point// 
ib1=IB1-5;
ib2=IB1+5;

mprintf('\n  Base current1              ib1=%.2f uA',ib1);
mprintf('\n  Base current2              ib2=%.2f uA',ib2);
ib1=ib1*1e-6;
ib2=ib2*1e-6;
//at the two intersections of ib1 and ib2 and vertical axis the two level of ic1,ic2  can be determine by drawing horizontal line
ic1=ICQ1-0.5;
ic2=ICQ1+0.5;
mprintf('\n  Collector current1              ic1=%.2f mA',ic1);
mprintf('\n  Collector current2              ic2=%.2f mA',ic2);
ic1=ic1*1e-3;
ic2=ic2*1e-3;
mprintf('\n. \************************************************************\');
Beta_AC=(ic2-ic1)/(ib2-ib1); // AC current gain
mprintf('\n 2)AC current gain of transistor in CE Confi.  Beta_AC:%2d',Beta_AC);
//////////////Calculate Beta DC//////////////////////////////////
mprintf('\n. \****************Calculation of AC resistance*****************\');
//At the operating point tangent is drawwn and either side of ic1  ic2 respective values of vce1 vce2 is considered for calculation of AC resistance // there is small change in ic for more change in vce//
vce1=VCEQ-5.2;
vce2=VCEQ+5.5;
mprintf('\n  Collector to emitter voltage1              vce1=%2d v',vce1);
mprintf('\n  Collector to emitter voltage2              vce2=%2d v',vce2);
mprintf('\n. \***********************************************************\');
R_out=(vce2-vce1)/(ic2-ic1);// AC resistance
R_out=R_out*1e-3; // Kilo ohms
mprintf('\n 3)Dynamic Output resistance  is                R_out:%1dKohm',R_out);
mprintf('\n. \***********************************************************\');
//output/////
 //******On the output characteristics of CE confi. in active 
 //      region select an operating point(VCEQ,ICQ) on load l 
//      ine*********                                          
//Enter the value of ICQ on the curve in mA ICQ: 2.7
//Enter the value of IB corresponding to ICQ in uA IB: 25
//Enter the Corresponding value of VCEQ : 7.5

//. *********************************************************
// Operating point Collector Current           ICQ:0.002700 A
// Corresponding Base Current                  IB:0.000025 A
// Recspective Collector to Emitter voltage is VCEQ:7.500000V
//. *********************************************************
// 1)DC current gain of transistor in CE Confi.  Beta_DC=108 
//. ***********************Calculation of βac*****************
//  Base current1              ib1=20.00 uA
//  Base current2              ib2=30.00 uA
//  Collector current1              ic1=2.20 mA
//  Collector current2              ic2=3.20 mA
//. ************************************************************
// 2)AC current gain of transistor in CE Confi.  Beta_AC:100
//. ****************Calculation of AC resistance*****************
//  Collector to emitter voltage1              vce1= 2 v
//  Collector to emitter voltage2              vce2=13 v
//. ***********************************************************
// 3)Dynamic Output resistance  is                R_out:10Kohm
//. *********************************************************** 
